<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice List</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }
        th, td {
            border: 1px solid #000;
            padding: 4px;
            text-align: center;
        }
        th {
            background-color: #eee;
        }
        .status-paid {
            color: green;
            font-weight: bold;
        }
        .status-due {
            color: red;
            font-weight: bold;
        }
        .total-row {
            background-color: aquamarine;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <h3 style="text-align:center;">Invoice List</h3>

    <table>
        <thead>
            <tr>
                <th rowspan="2">S/L</th>
                <th rowspan="2">Site Name</th>
                <th rowspan="2">Invoice No.</th>
                <th rowspan="2">Date</th>
                <th rowspan="2">Due Date</th>
                <th rowspan="2">Status</th>
                @foreach($itemsList as $item)
                    <th rowspan="2">{{ $item->item_name }}</th>
                @endforeach
                <th rowspan="2">Sub Total</th>
                <th rowspan="2">Tax Amount</th>
                <th rowspan="2">Previous Due</th>
                <th rowspan="2">Discount</th>
                <th rowspan="2">Grand Total</th>
                <th rowspan="2">Paid Amount</th>
                <th rowspan="2">Due Amount</th>
            </tr>
        </thead>
        <tbody>
            @forelse($invoiceList as $index => $inv)
                <tr class="{{ $inv['status_code'] == 'Paid' ? 'status-paid' : 'status-due' }}">
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $inv['site_info']['site_name'] ?? '' }}</td>
                    <td>{{ $inv['invoice_no'] }}</td>
                    <td>{{ \Carbon\Carbon::parse($inv['invoice_date'])->format('d-m-Y') }}</td>
                    <td>{{ \Carbon\Carbon::parse($inv['due_date'])->format('d-m-Y') }}</td>
                    <td>{{ ucfirst($inv['status_code']) }}</td>

                    @foreach($inv['details'] as $detail)
                        <td>{{ number_format($detail['item_final_amount'],2) }}</td>
                    @endforeach

                    <td>{{ number_format($inv['sub_total'],2) }}</td>
                    <td>{{ number_format($inv['total_tax'],2) }}</td>
                    <td>{{ number_format($inv['previous_due'],2) }}</td>
                    <td>{{ number_format($inv['discount_amount'],2) }}</td>
                    <td>{{ number_format($inv['grand_total'],2) }}</td>
                    <td>{{ number_format($inv['amount_paid'],2) }}</td>
                    <td>{{ number_format($inv['amount_due'],2) }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="15" style="color:red; text-align:center;">
                        Data Not Found!
                    </td>
                </tr>
            @endforelse

            {{-- Total Row --}}
            <tr class="total-row">
                <td colspan="6" style="text-align: right;">Total</td>
                @foreach($grand_totals['item_total_array'] as $item_total)
                    <td>{{ number_format($item_total['grand_total'],2) }}</td>
                @endforeach
                <td>{{ number_format($grand_totals['sub_total_sum'],2) }}</td>
                <td>{{ number_format($grand_totals['total_tax_sum'],2) }}</td>
                <td>{{ number_format($grand_totals['previous_due_sum'],2) }}</td>
                <td>{{ number_format($grand_totals['discount_amount_sum'],2) }}</td>
                <td>{{ number_format($grand_totals['grand_total_sum'],2) }}</td>
                <td>{{ number_format($grand_totals['amount_paid_sum'],2) }}</td>
                <td>{{ number_format($grand_totals['amount_due_sum'],2) }}</td>
            </tr>
        </tbody>
    </table>
</body>
</html>
